package gov.va.caret.controller.dashboard.config;

import com.liferay.portal.model.Role;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Facil;
import gov.va.caret.model.support.WorkType;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;


public abstract class FacilityDashboardConfig extends DashboardConfig implements InitDashboard {

	/**
	 * 
	 */
	private static final long serialVersionUID = -119344347382509643L;
	protected Map<Long,Facil> facilities;
	protected long groupId = 0;
	protected Collection<String> searchableWork = new HashSet<String>(Arrays.asList(new String[]{
			WorkType.CSC_APP.name(), 
			WorkType.ONLINE_APP.name(), 
			WorkType.CSC_WAIVER.name(), 
			WorkType.VCG_TRANSFER.name(), 
			WorkType.HOME_VISIT.name(), 
			WorkType.REFERRAL.name(), 
			WorkType.CALL_REFERRAL.name(),
			WorkType.DELAY_REVIEWED.name(),
			WorkType.APP_DELAY.name(),
			WorkType.HRC_REFERRAL.name(),
			WorkType.CSL_REFERRAL.name(),
			WorkType.HEC_REFERRAL.name()}));
	
	public abstract void setFacilityId( long facilityId );
	public abstract long getGroupId();
	public abstract Map<Long,Facil> getFacilities();
	public abstract void setFacilities(Map<Long,Facil> facilities);
	public abstract void configureFacility( PortletRequest request ) throws ApplicationWorkFlowException;
	public abstract void setUsers(PortletRequest request, List<Role> roles ) throws ApplicationWorkFlowException;
	
	@Override
	public void loadReports(PortletRequest request) throws ApplicationWorkFlowException {
		configureFacility( request );
		super.loadReports(request);
	}
	
}
